PRINT '> PRODUCAO - SCRIPT #0004';

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_ENT_NFE_PEND_DEL]'))
DROP TRIGGER [dbo].[TRG_EST_NF_ENT_NFE_PEND_DEL]
GO

CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_NFE_PEND_DEL] ON [dbo].[EST_NFE_LOTE_ENT]
FOR INSERT 
AS

	DECLARE @TP_LOTE INT;
	DECLARE @CD_NFE_LOTE INT;
	DECLARE @CD_NFE_LOTE_ENT INT;

	SET NOCOUNT ON
	DECLARE IDX_PEND CURSOR FAST_FORWARD FOR SELECT CD_NFE_LOTE, CD_NFE_LOTE_ENT FROM INSERTED
	OPEN IDX_PEND
	FETCH NEXT FROM IDX_PEND INTO @CD_NFE_LOTE, @CD_NFE_LOTE_ENT
	WHILE @@FETCH_STATUS = 0
	BEGIN        

		SET @TP_LOTE = ISNULL((SELECT TOP 1 TP_LOTE FROM EST_NFE_LOTE WHERE EST_NFE_LOTE.CD_NFE_LOTE = @CD_NFE_LOTE), -1)

		IF @TP_LOTE = 0
		BEGIN
			--Apgando a pendncia de entrada de nota fiscal eletronica
			DELETE
				d
			FROM
				EST_NF_ENT_NFE_PEND d
			INNER JOIN INSERTED t ON
					t.CD_EMP = d.CD_EMP
				AND t.CD_FILIAL = d.CD_FILIAL
				AND t.CD_NF = d.CD_NF
				AND t.CD_NFE_LOTE = @CD_NFE_LOTE
				AND t.CD_NFE_LOTE_ENT = @CD_NFE_LOTE_ENT
		END

		IF @TP_LOTE = 1
		BEGIN
			--Apgando a pendncia cancelamento de entrada de nota fiscal eletronica
			DELETE
				d
			FROM
				EST_NF_ENT_NFE_CANCEL_PEND d
			INNER JOIN INSERTED t ON
					t.CD_EMP = d.CD_EMP
				AND t.CD_FILIAL = d.CD_FILIAL
				AND t.CD_NF = d.CD_NF
				AND t.CD_NFE_LOTE = @CD_NFE_LOTE
				AND t.CD_NFE_LOTE_ENT = @CD_NFE_LOTE_ENT
		END

		IF @TP_LOTE = 4
		BEGIN
			--Apgando a pendncia Manifesto de confirmao de entrada de nota fiscal eletronica
			DELETE
				d
			FROM
				EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_MANIFESTO_PENDENTE d
			INNER JOIN INSERTED t ON
					t.CD_EMP = d.CD_EMP
				AND t.CD_FILIAL = d.CD_FILIAL
				AND t.CD_NF = d.CD_NF
				AND t.CD_NFE_LOTE = @CD_NFE_LOTE
				AND t.CD_NFE_LOTE_ENT = @CD_NFE_LOTE_ENT
		END

	FETCH NEXT FROM IDX_PEND INTO @CD_NFE_LOTE, @CD_NFE_LOTE_ENT
	END      

	--FECHANDO CURSOS
	CLOSE IDX_PEND;
	--DESALOCANDO CURSOS DA MEMORIA
	DEALLOCATE IDX_PEND;
GO
PRINT '    < [OK]';
